/*
 * File: City.java
 * =======================================================
 * A class representing a US city.
 *
 */
public class City {
	/* The name of the city. */
	private String name;
	
	/* Where the city is located. */
	private double longitude;
	private double latitude;
	
	/**
	 * Constructs a city given the name, longitude, and latitude of that city.
	 * 
	 * @param name The name of the city.
	 * @param longitude The longitude of the city.
	 * @param latitude The latitude of the city.
	 */
	public City(String name, double longitude, double latitude) {
		this.name = name;
		this.longitude = longitude;
		this.latitude = latitude;
	}
	
	/**
	 * Returns the name of this city.
	 *  
	 * @return The name of this city.
	 */
	public String getName() {
		return name;
	}
	
	/**
	 * Returns the longitude of this city.
	 * 
	 * @return The longitude of this city.
	 */
	public double getLongitude() {
		return longitude;
	}
	
	/**
	 * Returns the latitude of this city.
	 * 
	 * @return The latitude of this city.
	 */
	public double getLatitude() {
		return latitude;
	}
	
	/**
	 * Returns a human-readable representation of the city.
	 * 
	 * @return A human-readable representation of the city.
	 */
	public String toString() {
		return name + " (" + latitude + ", " + longitude + ")";
	}
}
